#include "pch.h"

#include "Mem.hpp"
#include "Common.hpp"
#include "CfgParse.hpp"
#include "Misc.hpp"
#include "Links.h"
#include "Areas.h"
#include "Msg.hpp"
#include "Tic.hpp"
#include "crc32.hpp"
#include "Temp.hpp"
#include "File.h"

#include "CfgLexems.hpp"
#include "WELexems.h"

#include "MsgAttrs.h"

#include "Adrenalin.h"

#include "LinksManager.h"
#include "AreasManager.h"

// TODO: not all info printed (see links, areas)

/**
 * Implementation of void CAdrenalin::PrintDebugInfo()
 */

void CAdrenalin::PrintDebugInfo() {
	int		i;
	TCHAR	szChar[2];

	TCHAR	szBuf[1024];

	g_vars.m_log << CLog::Push(new CLog::FileOut(false))
		     << CLog::Push(new CLog::StdErr(false))
		     << CLog::Push(new CLog::StdOut(true));

	g_vars.m_log << _T("Debug information\n");

	g_vars.m_addrMain.ToString( szBuf );
	g_vars.m_log << _T("System: ") << szBuf << _T("\n");
	for (i = 0; i < g_vars.m_vAKAAddr.size(); i++) {
		g_vars.m_vAKAAddr[i].ToString( szBuf );
		g_vars.m_log << _T("   AKA: ") << szBuf << _T("\n");
	}
	g_vars.m_log << _T(" SysOp: ") << g_vars.m_szSysOp << _T("\n");

	g_vars.m_log << _T("Directories:\n");
	g_vars.m_log << _T("       Inbound: ") << g_vars.m_szInboundPath      << TEXT_EOL
		     << _T("      Outbound: ") << g_vars.m_szOutboundPath     << TEXT_EOL
		     << _T("  BinkOutbound: ") << g_vars.m_szBinkOutboundPath << TEXT_EOL;

	CommonDataPtr	commonData = CCommonData::getInstance();

	// file boxes
	g_vars.m_log << TEXT("     FileBoxes: ");
	if (commonData->areLongFileBoxes() || commonData->getFileBoxesPath().size() == 0) {
		g_vars.m_log << TEXT("<undefined>");
	} else {
		g_vars.m_log << commonData->getFileBoxesPath();
	}
	g_vars.m_log << TEXT_EOL;

	// long file boxes
	g_vars.m_log << TEXT(" LongFileBoxes: ");
	if (!commonData->areLongFileBoxes() || commonData->getFileBoxesPath().size() == 0) {
		g_vars.m_log << TEXT("<undefined>");
	} else {
		g_vars.m_log << commonData->getFileBoxesPath();
	}
	g_vars.m_log << TEXT_EOL;

	g_vars.m_log << _T("       Netmail: ") << g_vars.m_szNetmailPath      << TEXT_EOL
				 << _T("       BadTics: ") << g_vars.m_szBadTicsPath      << TEXT_EOL
				 << _T("       NewTics: ") << g_vars.m_szNewTicsPath      << TEXT_EOL
				 << _T(" ProcessedTics: ");
	if (g_vars.m_szProcessedTicsPath[0] == TEXT('\0')) {
		g_vars.m_log << TEXT("undefined (TICs will be removed after processing)\n");
	}
	else {
		g_vars.m_log << g_vars.m_szProcessedTicsPath << TEXT_EOL;
	}
    
	g_vars.m_log << TEXT("      Filelist: ") << g_vars.m_szFilelistFileName << TEXT_EOL;
	g_vars.m_log << TEXT("FilelistFormat: ") << g_vars.m_fileListFormat.getFormat() << TEXT_EOL;

    // requests log file
    g_vars.m_log << TEXT("Requests log: ")
                 << (IsEmptyStr(requestsLogFileName) ? TEXT("undefined")
                                                     : requestsLogFileName)
                 << TEXT_EOL;

	g_vars.m_log << _T("Flags:\n");
	g_vars.m_log << _T("    after fix: ")
		     << ((*g_vars.m_szFixFlagName != '\0') ? g_vars.m_szFixFlagName : _T("none"))
		     << _T("\n")
		     << _T("   after toss: ")
		     << ((*g_vars.m_szTossFlagName != '\0') ? g_vars.m_szTossFlagName : _T("none"))
		     << _T("\n")
		     << _T("  after hatch: ")
		     << ((*g_vars.m_szHatchFlagName != '\0') ? g_vars.m_szHatchFlagName : _T("none"))
		     << _T("\n");
    
	g_vars.m_log << _T("Alias(es):\n");
	for (i = 0; i < g_vars.m_vsAliases.size(); i++) {
		g_vars.m_log << _T("  ") << g_vars.m_vsAliases[i] << _T("\n");
	}

	// attributes
	g_vars.m_log << TEXT("Reply message attributes: ") 
		     << MsgAttrsToString( g_vars.m_nReplyMessageAttrs,
					  g_vars.m_nReplyMessageFlags )
		     << TEXT_EOL;

	// warn sysop
	g_vars.m_log << TEXT("Warn sysop by mail about:");
	if (g_vars.m_nWarnSysopByMail == 0) {
		g_vars.m_log << TEXT( " nothing" );
	}
	else {
		if ((g_vars.m_nWarnSysopByMail & WARN_SYSOP_ABOUT_WARNINGS) != 0) {
			g_vars.m_log << TEXT( " warnings" );
		}
		if ((g_vars.m_nWarnSysopByMail & WARN_SYSOP_ABOUT_ERRORS) != 0) {
			g_vars.m_log << TEXT( " errors" );
		}
	}
	g_vars.m_log << TEXT_EOL;

	// no mail notify
	g_vars.m_log << TEXT("No mail notifications for: ");
	if (g_vars.m_nNoMailNotify == 0) {
		g_vars.m_log << "nothing";
	}
	else {
		g_vars.m_log << "BasePurge";
	}
	g_vars.m_log << TEXT_EOL;

	// links
	g_vars.m_log << _T("Link(s):\n");
	for (CLinksManager::CIterator itLink = CLinksManager::getInstance()->begin();
		 itLink != CLinksManager::getInstance()->end(); ++itLink)
	{
		PLink	link = (*itLink);
		link->getAddress().ToString( szBuf );
		g_vars.m_log << _T("  --------------\n")
				 << _T("        address: ") << szBuf << _T("\n")
				 << _T("  --------------\n")
				 << TEXT("           name: ") << link->getName() << TEXT("\n")
				 << TEXT("     robot name: ") << link->getRobotName() << TEXT("\n")
				 << _T("       password: ") << link->getPassword().c_str() << TEXT_EOL;

		// outbound type
		g_vars.m_log << TEXT("  outbound type: ");
		switch (link->getOutboundType()) {
			case OT_BINKLEY:
				g_vars.m_log << TEXT("binkley");
				break;
			case OT_FILE_BOXES:
				g_vars.m_log << TEXT("fileBoxes");
				break;
		}
		g_vars.m_log << TEXT_EOL;

		// flavour type
		g_vars.m_log << _T("        flavour: ");
		switch (link->getFlavourType()) {
		case FT_NORMAL:
			g_vars.m_log << _T("normal");
			break;
		case FT_CRASH:
			g_vars.m_log << _T("crash");
			break;
		case FT_DIRECT:
			g_vars.m_log << _T("direct");
			break;
		case FT_HOLD:
			g_vars.m_log << _T("hold");
			break;
		case FT_IMMEDIATE:
			g_vars.m_log << _T("immediate");
			break;
		}
		g_vars.m_log << _T("\n")
				 << _T("  area creation: ");
		if (!link->canCreateAreas())
			g_vars.m_log << _T("not ");
		g_vars.m_log << _T("allowed\n")
				 << _T("       priority: ") << link->getSendPriority() << _T("/") << link->getReceivePriority() << _T("/");

		int groupsCount = 0;

		lstrcpy( szChar, _T("A") );
		while (*szChar <= _T('Z')) {
			if (link->canAccessGroup( szChar )) {
				g_vars.m_log << szChar;
				++groupsCount;
			}
			++(*szChar);
		}
		if (groupsCount == 0) {
			g_vars.m_log << TEXT("none");
		}
		g_vars.m_log << _T("\n");
		g_vars.m_log << _T("  default group: ");
		if (link->getDefaultGroup().length() == 0)
			g_vars.m_log << _T("no\n");
		else {
			g_vars.m_log << link->getDefaultGroup().c_str() << TEXT_EOL;
		}
		link->getOurAddress().ToString( szBuf );
		g_vars.m_log << _T("    our address: ") << szBuf << TEXT_EOL;

		// available areas file name
		g_vars.m_log << TEXT("     AvailAreas: ");
		if (link->getAvailAreasFileName().size() > 0) {
			g_vars.m_log << link->getAvailAreasFileName();
		} else {
			g_vars.m_log << TEXT("<undefined>");
		}
		g_vars.m_log << TEXT_EOL;
	}

	// Areas
	g_vars.m_log << TEXT("Area(s):\n");
	int	areasCount = CAreasManager::getInstance()->getAreasCount();
	for (i = 0; i < areasCount; i++) {
		PArea	area = CAreasManager::getInstance()->getArea( i );
		g_vars.m_log << _T("---\n");
		g_vars.m_log << _T("    name: ") << area->getName() << _T("\n")
				 << _T("    path: ") << area->getPath() << _T("\n")
				 << _T("   wpath: ") << area->getWorkingPath() << _T("\n")
				 << _T("    desc: ") << area->getDescription() << _T("\n")
				 << _T("  send access: ") << area->getSendPriority() << _T("\n")
				 << _T("  receive access: ") << area->getReceivePriority() << _T("\n")
				 << _T("   group: ") << area->getGroup()->getName() << _T("\n")
				 << _T("  passthrough: ");
		if (area->hasFlag( CArea::FLAG_PASSTHROUGH ))
			g_vars.m_log << _T("yes\n");
		else
			g_vars.m_log << _T("no\n");
		g_vars.m_log << _T("  veto manual purge: ");
		if (area->hasFlag( CArea::FLAG_VETO_MANUAL_PURGE ))
			g_vars.m_log << _T("yes\n");
		else
			g_vars.m_log << _T("no\n");
		g_vars.m_log << TEXT("  open for resend: ")
			         << (area->hasFlag( CArea::FLAG_OPEN_FOR_RESEND ) ? TEXT("yes") : TEXT("no")) << TEXT_EOL;

		// outbound
		g_vars.m_log << TEXT("         outbound: ");
		if (area->isOutboundDefined()) {
			switch (area->getOutboundType()) {
				case OT_BINKLEY:
					g_vars.m_log << TEXT("binkley");
					break;
				case OT_FILE_BOXES:
					g_vars.m_log << TEXT("fileBoxes");
					break;
			}
		} else {
			g_vars.m_log << "<undefined>";
		}
		g_vars.m_log << TEXT_EOL;

		int	tiesCount = area->getTiesCount();
		if (tiesCount == 0) {
			g_vars.m_log << _T("  no links linked\n");
		}
		else {
			g_vars.m_log << _T("  linked:\n");
			for (int j = 0; j < tiesCount; j++) {
				ConstTiePtr	tie = area->getTie( j );
				g_vars.m_log << _T("  ") << tie->getLink()->getAddress().toString() << _T(", ")
						 << tie->getRouteType() << _T("\n");
			}
		}
	}

	// restore all 3 modes (StdOut, StdErr, FileOut)

	g_vars.m_log << CLog::Pop() << CLog::Pop() << CLog::Pop();
}
